<?php

namespace App\Models\Piket;

use CodeIgniter\Model;

class PelanggaranModel extends Model
{
    protected $table      = 'tb_pelanggaran';
    protected $primaryKey = 'id_pelanggaran';

    protected $allowedFields = [
        'id_siswa',
        'tanggal',
        'jenis_pelanggaran',
        'poin',
        'keterangan',
        'id_guru'
    ];

    /**
     * Rekap total poin pelanggaran per siswa
     */
    public function rekapPoin($id_kelas = null)
    {
        $builder = $this->db->table('tb_pelanggaran p');
        $builder->select('
            s.id_siswa,
            s.nis,
            s.nama_siswa,
            k.kelas,
            SUM(p.poin) AS total_poin
        ');
        $builder->join('tb_siswa s', 's.id_siswa = p.id_siswa');
        $builder->join('tb_kelas k', 'k.id_kelas = s.id_kelas');
        $builder->groupBy('s.id_siswa');
        $builder->orderBy('total_poin', 'DESC');

        if ($id_kelas) {
            $builder->where('s.id_kelas', $id_kelas);
        }

        return $builder->get()->getResultArray();
    }
}
